// SCRF.h - Header file for Source Code Resource Files
// by Noose 25/5/98
// Revisions: 26/5/98 Noose - Added FunctionList()

#ifndef SCRF_H
#define SCRF_H

#define TRUE                1
#define FALSE               0

#define MAX_FILENAME_LEN    256
#define MAX_OWNER_LEN       128
#define MAX_FUNCNAME_LEN    128
#define MAX_CREATOR_LEN     128
#define FIRST_LINE          1

#define INSERT_AT_END       0
#define INSERT_BEFORE       1
#define INSERT_AFTER        2

#define OTHER_LINE          0
#define FUNCTION_NAME       1
#define OWNER_NAME          2
#define CODE_START          3
#define DESCRIPTION_TEXT    4
#define CREATOR_NAME        5
#define UNICODE_START       6
#define ANSICODE_START      7
#define DATA_START          8
#define END_FLAG            999

#define TYPE_NONE           0
#define TYPE_UNICODE        1
#define TYPE_ANSI           2

#include <stdio.h>

#include "lzari.hpp"

class _export TCodeLine {
    char            *_Text;
    TCodeLine       *_Next,*_Prev;
public:
                    TCodeLine(char *SomeText);
                    ~TCodeLine(void);
    char            *Text(void);

    TCodeLine       *Next(void);
    TCodeLine       *Prev(void);
    void            Prev(TCodeLine *PrevPtr);
    void            Next(TCodeLine *NextPtr);
};

class _export TCodeElement {

    char            *_CodeName;
    TCodeElement    *_Next,*_Prev;
    TCodeLine       *_SourceCode;
    TCodeLine       *_LinesOfData;
    char            *_Owner;

    unsigned long   _numLines;
    unsigned long   _descLines;
    unsigned long   _dataLines;

    char            *_DC;
    TCodeLine       *_Description;
    char            *_Creator;
    int             _CodeType;

    void            DeleteLines(TCodeLine *CurrLine);

public:
                    TCodeElement(char *codeName,char *Owner);
                   ~TCodeElement();

    char            *CodeName(void);
    unsigned long   numLines(void);
    unsigned long   descLines(void);
    unsigned long   dataLines(void);
    char            *Owner(void);

    int             Type(void);
    void            Type(int aType);

    TCodeElement    *Next(void);
    TCodeElement    *Prev(void);
    void            Next(TCodeElement *nextptr);
    void            Prev(TCodeElement *prevptr);

    TCodeLine       *Line(unsigned long aLine);
    TCodeLine       *Desc(unsigned long aLine);
    TCodeLine       *Data(unsigned long aLine);
    char            *Creator(void);
    void            Creator(char *);

    char            *DCreator(void);
    void            DCreator(char *);

    void            InsertLine(unsigned long aLine,char *codeLine,int Where);
    void            AddDesc(char *descLine);
    void            AddData(char *dataLine);
};


class _export TSourceCode {

    char            _fileName[MAX_FILENAME_LEN];
    char            _Owner[MAX_OWNER_LEN];
    TCodeElement    *_SourceCodeList;
    void            BuildData(char *f);
    void            FieldContents(char *line,char *Buffer);
    LZAri           *LZInput;
    void            Add(TCodeElement *aCodeElem);
    unsigned long   _numFunctions;

    int             FoundInBuffer(char *Start,char *Text,unsigned long len);

public:
                    TSourceCode(char *fileName,char *Owner);
                   ~TSourceCode();

    char            *fileName(void);

    TCodeElement    *Block(char *IndexName);
    TCodeElement    *Block(char *IndexName,int CodeType);
    unsigned long   numFunctions(void);
    void            AddFromOther(char *o);
    void            AddFromOther(char *o,char *f);

    char            *FunctionList(void);        // Remember to delete() it...
    char            *FunctionList(int CodeType,char *Owner);
    char 			*FunctionList(char *Owner);

    char            *OwnerList(void);

    unsigned long   CreateBuffer(char *Buffer);
    void            OutputSCR(char *fn);
};    

#endif
